<?php $__env->startSection('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.edit')); ?>

<?php $__env->startSection('breadcrumb-links'); ?>
    <?php echo $__env->make('backend.auth.user.includes.breadcrumb-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo e(html()->modelForm($user, 'PATCH', route('admin.auth.user.update', $user->id))->class('form-horizontal')->open()); ?>

    
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        <?php echo app('translator')->get('labels.backend.access.users.management'); ?>
                        <small class="text-muted"><?php echo app('translator')->get('labels.backend.access.users.edit'); ?></small>
                    </h4>
                </div><!--col-->
            </div><!--row-->

            <hr>

            <div class="row mt-4 mb-4">
                <div class="col">
                    <div class="form-group row">
                    <?php echo e(html()->label(__('validation.attributes.backend.access.users.first_name'))->class('col-md-2 form-control-label')->for('first_name')); ?>


                        <div class="col-md-10">
                            <?php echo e(html()->text('first_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                ->attribute('maxlength', 191)
                                ->required()); ?>

                        </div><!--col-->
                    </div><!--form-group-->

                    <div class="form-group row">
                        <?php echo e(html()->label(__('validation.attributes.backend.access.users.last_name'))->class('col-md-2 form-control-label')->for('last_name')); ?>


                        <div class="col-md-10">
                            <?php echo e(html()->text('last_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                ->attribute('maxlength', 191)
                                ->required()); ?>

                        </div><!--col-->
                    </div><!--form-group-->

                    <div class="form-group row">
                        <?php echo e(html()->label(__('validation.attributes.backend.access.users.email'))->class('col-md-2 form-control-label')->for('email')); ?>


                        <div class="col-md-10">
                            <?php echo e(html()->email('email')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.email'))
                                ->attribute('maxlength', 191)
                                ->required()); ?>

                        </div><!--col-->
                    </div><!--form-group-->

                    <?php echo $__env->make('backend.auth.user.parent-relation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        

                    <div class="form-group row" style="display:none !important">
                        <?php echo e(html()->label('Abilities')->class('col-md-2 form-control-label')); ?>


                        <div class="table-responsive col-md-10">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('labels.backend.access.users.table.roles'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <?php if($roles->count()): ?>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="checkbox d-flex align-items-center">
                                                                <?php echo e(html()->label(
                                                                        html()->checkbox('roles[]', in_array($role->name, $userRoles), $role->name)
                                                                                ->class('switch-input')
                                                                                ->id('role-'.$role->id)
                                                                        . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                                                    ->class('switch switch-label switch-pill switch-primary mr-2')
                                                                    ->for('role-'.$role->id)); ?>

                                                                <?php echo e(html()->label(ucwords($role->name))->for('role-'.$role->id)); ?>

                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <?php if($role->id != 1): ?>
                                                                <?php if($role->permissions->count()): ?>
                                                                    <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <i class="fas fa-dot-circle"></i> <?php echo e(ucwords($permission->name)); ?>

                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                    <?php echo app('translator')->get('labels.general.none'); ?>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php echo app('translator')->get('labels.backend.access.users.all_permissions'); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div><!--card-->
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </td>
                                       
                                    </tr>
                                </tbody>
                            </table>
                        </div><!--col-->
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->

        <div class="card-footer">
            <div class="row">
                <div class="col">
                <?php if($userrole=='superAdmin'): ?>
                        <?php echo e(form_cancel(route('admin.auth.user.admin'), __('buttons.general.cancel'))); ?>

                    <?php elseif($userrole=='admin'): ?>
                    <?php echo e(form_cancel(route('admin.auth.user.superstockez'), __('buttons.general.cancel'))); ?>

                    <?php else: ?>
                    <?php echo e(form_cancel(route('admin.auth.user.stockez'), __('buttons.general.cancel'))); ?>

                    <?php endif; ?>
                </div><!--col-->

                <div class="col text-right">
                    <?php echo e(form_submit(__('buttons.general.crud.update'))); ?>

                </div><!--row-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
<?php echo e(html()->closeModelForm()); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function () {
            var parentForm  = $('.sub_child');

            parentForm.on('change', function() {
                event.preventDefault();
                $.ajax({
                    url:      '<?php echo e(route('admin.auth.user.withparent')); ?>',
                    type:     "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        'parentId': $(this).val(),
                    },
                    success: function(data) {
                        $('#subparenthtml').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;

                
            });

           
            
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/auth/user/edit.blade.php ENDPATH**/ ?>