<?php

use App\Http\Controllers\Backend\Credit\CreditController;
use App\Http\Controllers\Backend\Auth\Role\RoleController;
use App\Http\Controllers\Backend\Auth\User\UserController;
use App\Http\Controllers\Backend\Auth\MacAddressController;
use App\Http\Controllers\Backend\License\LicenseController;
use App\Http\Controllers\Backend\Auth\User\AccountController;
use App\Http\Controllers\Backend\Auth\Role\PermissionController;
use App\Http\Controllers\Backend\Auth\User\UserSocialController;
use App\Http\Controllers\Backend\Auth\User\UserStatusController;
use App\Http\Controllers\Backend\Auth\User\UserSessionController;
use App\Http\Controllers\Backend\Auth\User\UserPasswordController;
use App\Http\Controllers\Backend\Auth\User\UserConfirmationController;

// All route names are prefixed with 'admin.auth'.
Route::group([
    'prefix' => 'auth',
    'as' => 'auth.',
    'namespace' => 'Auth',
    //'middleware' => 'role:'.config('access.users.admin_role'),
], function () {
    // User Management
    Route::group(['namespace' => 'User'], function () {
        // User Account Specific
        Route::get('account', [AccountController::class, 'index'])->name('user.account');
        // User Status'
        Route::get('user/deactivated', [UserStatusController::class, 'getDeactivated'])->name('user.deactivated');
        Route::get('user/deleted', [UserStatusController::class, 'getDeleted'])->name('user.deleted');
        Route::post('userparentlist', [UserController::class, 'userwithparticularparent'])->name('user.withparent');
        // User CRUD
        Route::get('user', [UserController::class, 'index'])->name('user.index');
        Route::get('user/create/{userrole?}', [UserController::class, 'create'])->name('user.create');
        Route::post('user', [UserController::class, 'store'])->name('user.store');
        Route::get('superadminuser/{id?}', [UserController::class, 'adminindex'])->name('user.admin');
        Route::get('admin/{id?}', [UserController::class, 'superstockezindex'])->name('user.superstockez');
        Route::get('agent/{id?}', [UserController::class, 'stockezindex'])->name('user.stockez');
        Route::get('agenttest/{id?}', [UserController::class, 'agentindex'])->name('user.agent');
        // Specific User
        Route::group(['prefix' => 'user/{user}'], function () {
            // User
            Route::get('/', [UserController::class, 'show'])->name('user.show');
            Route::get('edit', [UserController::class, 'edit'])->name('user.edit');
            Route::patch('/', [UserController::class, 'update'])->name('user.update');
            Route::delete('/', [UserController::class, 'destroy'])->name('user.destroy');

            // Account
            Route::get('account/confirm/resend', [UserConfirmationController::class, 'sendConfirmationEmail'])->name('user.account.confirm.resend');

            // Status
            Route::get('mark/{status}', [UserStatusController::class, 'mark'])->name('user.mark')->where(['status' => '[0,1]']);

            // Social
            Route::delete('social/{social}/unlink', [UserSocialController::class, 'unlink'])->name('user.social.unlink');

            // Confirmation
            Route::get('confirm', [UserConfirmationController::class, 'confirm'])->name('user.confirm');
            Route::get('unconfirm', [UserConfirmationController::class, 'unconfirm'])->name('user.unconfirm');

            // Password
            Route::get('password/change', [UserPasswordController::class, 'edit'])->name('user.change-password');
            Route::patch('password/change', [UserPasswordController::class, 'update'])->name('user.change-password.post');

            // Session
            Route::get('clear-session', [UserSessionController::class, 'clearSession'])->name('user.clear-session');

            // Deleted
            Route::get('delete', [UserStatusController::class, 'delete'])->name('user.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restore'])->name('user.restore');
        });
    });

    // Role Management
    Route::group(['namespace' => 'Role'], function () {
        Route::get('role', [RoleController::class, 'index'])->name('role.index');
        Route::get('role/create', [RoleController::class, 'create'])->name('role.create');
        Route::post('role', [RoleController::class, 'store'])->name('role.store');

        Route::group(['prefix' => 'role/{role}'], function () {
            Route::get('edit', [RoleController::class, 'edit'])->name('role.edit');
            Route::patch('/', [RoleController::class, 'update'])->name('role.update');
            Route::delete('/', [RoleController::class, 'destroy'])->name('role.destroy');
        });
    });

    // Permission Management
    Route::group(['namespace' => 'Permission'], function () {
        Route::get('permission', [PermissionController::class, 'index'])->name('permission.index');
        Route::get('permission/create', [PermissionController::class, 'create'])->name('permission.create');
        Route::post('permission', [PermissionController::class, 'store'])->name('permission.store');

        Route::group(['prefix' => 'permission/{permission}'], function () {
            Route::get('edit', [PermissionController::class, 'edit'])->name('permission.edit');
            Route::patch('/', [PermissionController::class, 'update'])->name('permission.update');
            Route::delete('/', [PermissionController::class, 'destroy'])->name('permission.destroy');
        });
    });

    //credit
    Route::group(['namespace' => 'Credit'], function () {
        Route::get('credit', [CreditController::class, 'index'])->name('credit.index');
        Route::post('creditDetails', [CreditController::class, 'creditDetails'])->name('credit.creditdetails');
        Route::get('transfercredit/{userId}', [CreditController::class, 'transferCredit'])->name('credit.transfercredit');
        Route::get('adjustcredit/{userId}', [CreditController::class, 'adjustCredit'])->name('credit.adjustcredit');
        Route::post('creditstore/{userId}', [CreditController::class, 'store'])->name('credit.store');
    });

    //credit
    Route::group(['namespace' => 'credit'], function () {
        Route::get('credit', [CreditController::class, 'index'])->name('credit.index');
        Route::post('creditDetails', [CreditController::class, 'creditDetails'])->name('credit.creditdetails');
        Route::get('transfercredit/{userId}', [CreditController::class, 'transferCredit'])->name('credit.transfercredit');
        Route::get('adjustcredit/{userId}', [CreditController::class, 'adjustCredit'])->name('credit.adjustcredit');
    });

    //licence type
    Route::group(['namespace' => 'licenseType'], function () {
        Route::get('licenseType', [LicenseController::class, 'index'])->name('licensetype.index');
        Route::get('licenseType/create', [LicenseController::class, 'create'])->name('licensetype.create');
        Route::post('licenseType/store', [LicenseController::class, 'store'])->name('licensetype.store');
        Route::group(['prefix' => 'licenceType/{licenseType}'], function () {
            Route::get('edit', [LicenseController::class, 'edit'])->name('licensetype.edit');
            Route::patch('/', [LicenseController::class, 'update'])->name('licensetype.update');
            Route::delete('/', [LicenseController::class, 'destroy'])->name('licensetype.destroy');
        });
    });

    //license
    Route::group(['namespace' => 'license'], function () {
        Route::get('generatelicense', [LicenseController::class, 'generatelicense'])->name('license.generatelicense');
        Route::post('licenseDetails', [LicenseController::class, 'licensedetails'])->name('license.licensedetails');
        Route::post('license/store', [LicenseController::class, 'storelicense'])->name('license.store');
        Route::get('license', [LicenseController::class, 'licenseindex'])->name('license.index');
        Route::get('ipaddress/{macId}', [LicenseController::class, 'ipAddressindex'])->name('license.ipAddressindex');
        Route::post('licensewithmac', [LicenseController::class, 'licenseMacindex'])->name('license.macindex');
        Route::group(['prefix' => 'licence/{license}'], function () {
            Route::get('edit', [LicenseController::class, 'licenseedit'])->name('license.edit');
            Route::patch('/', [LicenseController::class, 'licenseupdate'])->name('license.update');
            Route::get('generateselflicense', [LicenseController::class, 'generateselflicense'])->name('license.generateselflicense');
        });
    });

    Route::group(
        ['prefix' => 'macAddresses'],
        function () {
            Route::get('/', [MacAddressController::class, 'index'])->name('macs.index');
            Route::get('{mac}/edit', [MacAddressController::class, 'edit'])->name('macs.edit');
            Route::get('{mac}/licenses', [MacAddressController::class, 'licenses'])->name('macs.licenses');
            Route::patch('{mac}', [MacAddressController::class, 'update'])->name('macs.update');
        }
    );
});
