@extends('backend.layouts.app')

@section('title', __('labels.backend.access.license.licensetype.management') . ' | ' . __('labels.backend.access.license.licensetype.create'))

@section('content')
{{ html()->form('POST', route('admin.auth.licensetype.store'))->class('form-horizontal')->open() }}
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        @lang('labels.backend.access.license.licensetype.management')
                        <small class="text-muted">@lang('labels.backend.access.license.licensetype.create')</small>
                    </h4>
                </div><!--col-->
            </div><!--row-->

            <hr>

            <div class="row mt-4">
                <div class="col">
                    <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.license.licensetype.name'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                            {{ html()->text('name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.permissions.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }}
                        </div><!--col-->
                    </div><!--form-group-->

                    <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.license.licensetype.duration'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                            {{ html()->number('duration')
                                ->class('form-control')
                                ->required()
                                ->placeholder(__('validation.attributes.backend.access.license.licensetype.duration'))
                                ->autofocus() }}
                        </div><!--col-->
                    </div><!--form-group-->

                    <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.license.licensetype.status'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                        <div class="checkbox d-flex align-items-center">
                                        {{ html()->label(
                                                html()->checkbox('status',null)
                                                      ->class('switch-input')
                                                      ->id('status')
                                                    . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                                ->class('switch switch-label switch-pill switch-primary mr-2')
                                            ->for('status') }}
                                    </div>
                        </div><!--col-->
                    </div><!--form-group-->


                    <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.license.licensetype.keytype'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                        {{ html()->select('licensekey',$licensekey, null)
        ->class('form-control')
        ->placeholder(__('labels.backend.access.dropboxselect'))
        ->required() }}
                        </div><!--col-->
                    </div><!--form-group-->

                   
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->

        <div class="card-footer">
            <div class="row">
                <div class="col">
                    {{ form_cancel(route('admin.auth.licensetype.index'), __('buttons.general.cancel')) }}
                </div><!--col-->

                <div class="col text-right">
                    {{ form_submit(__('buttons.general.crud.create')) }}
                </div><!--col-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
{{ html()->form()->close() }}
@endsection
