@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.license.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.license.management')
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
            <div class="input-group md-form form-sm form-1 pl-0">
  <div class="input-group-prepend">
    <span class="input-group-text purple lighten-3" id="basic-text1"><i class="fas fa-search text-white"
        aria-hidden="true"></i></span>
  </div>
  <input class="form-control my-0 py-1" id="macsearch" type="text" placeholder="Search" aria-label="Search">
</div>
                @include('backend.license.header-button')
                <div class="float-left mt-4">
    <input id="searchByMacAddress" type="checkbox" name="searchByMacAddress">
    <label for="searchByMacAddress">Search by mac addresses</label>
  </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4" id="lic_acc">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.license.table.name')</th>
                            <th>@lang('labels.backend.access.license.table.refferuser')</th>
                            <th>@lang('labels.backend.access.license.table.type')</th>
                            <th>@lang('labels.backend.access.license.table.status')</th>
                            @if ($logged_in_user->isAdmin())
                            <th>@lang('labels.general.actions')</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($licenses as $license)
                                <tr>
                                    <td>{{ $license->key_uuid }}</td>
                                    <td>
                                    {{ $license->licenseUserDetails->email ?? '' }}
                                    </td>
                                    <td>
                                    {{ $license->licenseTypeDetails->name }}
                                    </td>
                                    <td>
                                    {{ $license->status }}
                                    </td>
                                    
                                    <td>@include('backend.license.actions', ['license' => $license])</td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                  
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $licenses->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

@push('after-scripts')
    <script>
        $(function () {
      

    $("#macsearch").on('keyup',function(event){

     if(event.keyCode == 13){
        event.preventDefault();
                $.ajax({
                    url:      '{{route('admin.auth.license.macindex')}}',
                    type:     "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'searchKey': $(this).val(),
                        'searchByMacAddress': $('#searchByMacAddress').prop("checked") == true
                    },
                    success: function(data) {
                        $('#lic_acc').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;
     }
 });

        });
    </script>
@endpush
