@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.credit.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.credit.management')
                </h4>
            </div><!--col-->
            <div class="col-sm-7 ">
            <div class="btn-toolbar float-right">
                <span> @lang('labels.backend.access.credit.title') : {{ !empty($userDetail->credit) ? $userDetail->credit : 0 }}</span>
                </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
            <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.permissions.name'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                            {{ html()->text('tags')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.permissions.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }}
            
                        </div><!--col-->
                    </div><!--form-group-->
                    <div id ="subhtml">
                    </div>
            </div>
            </div>

    </div><!--card-body-->
</div><!--card-->
@endsection

@push('after-scripts')
    <script>
        $(function () {
            var availableTags = @json($userList);
    $( "#tags" ).autocomplete({
      source: availableTags
    });

    function tranferCredit() {
      alert("b");
    }

    $("#tags").on('keypress',function(event){
     if(event.which == 13){
        event.preventDefault();
                $.ajax({
                    url:      '{{route('admin.auth.credit.creditdetails')}}',
                    type:     "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'userDetail': $(this).val(),
                    },
                    success: function(data) {
                        $('#subhtml').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;
     }
 });

        });
    </script>
@endpush
