<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


/**
 * Class Role.
 */
class LicenseMacMapping extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'key_mac_mapping';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['lincensekeyId','macDetailId','allocatedUserId','license_key_status','mac_status'];

    public function license() {
        return $this->belongsTo('App\Models\License','lincensekeyId','id');
    }

    public function macDetail() {
        return $this->belongsTo('App\Models\MacDetail','macDetailId','id');
    }

    public function allocatedUser()
    {
        return $this->belongsTo('App\Models\Auth\User','allocatedUserId','id');
    }

}
