<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


/**
 * Class Role.
 */
class LicenseLedger extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'license_ledger';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['lincensekeyId','macDetailId','apiStatus','ipAddress'];

    public function license() {
        return $this->belongsTo('App\Models\License','lincensekeyId','id');
    }

    public function macDetail() {
        return $this->belongsTo('App\Models\MacDetail','macDetailId','id');
    }


}
