<?php

namespace App\Models\Auth\Traits\Relationship;

use App\Models\Auth\SocialAccount;
use App\Models\Auth\PasswordHistory;
use App\Models\Auth\UserDetail;
use App\Models\{License, LicenseMacMapping};

/**
 * Class UserRelationship.
 */
trait UserRelationship
{
    /**
     * @return mixed
     */
    public function providers()
    {
        return $this->hasMany(SocialAccount::class);
    }

    /**
     * @return mixed
     */
    public function passwordHistories()
    {
        return $this->hasMany(PasswordHistory::class);
    }

    public function userDetails()
        {
            return $this->hasMany(UserDetail::class);
        }

        public function refferaluser()
        {
            return $this->hasMany(License::class);
        }
        
        public function licenseuser()
        {
            return $this->hasMany(License::class);
        } 

        public function licensemapuser()
        {
            return $this->hasMany(LicenseMacMapping::class);
        } 
}
