<?php

namespace App\Http\Controllers\Backend\Credit;

use App\Models\Auth\{User, UserDetail};
use App\Http\Controllers\Controller;
use App\Events\Backend\Auth\User\UserDeleted;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\UserRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Http\Requests\Backend\Auth\User\StoreUserRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Http\Requests\Backend\Auth\User\UpdateUserRequest;
use App\Http\Controllers\Backend\helper\UserFunction;
use App\Repositories\Backend\Credit\CreditRepository;
use Illuminate\Http\Request;
use App\Exceptions\GeneralException;

/**
 * Class UserController.
 */
class CreditController extends Controller
{
    /**
     * @var creditRepository
     */
    protected $creditRepository;

    /**
     * @var UserFunction
     */
    protected $userFunction;

    /**
     * UserController constructor.
     *
     * @param CreditRepository $creditRepository
     */
    public function __construct(CreditRepository $creditRepository, UserFunction $userFunction)
    {
        
        $this->creditRepository = $creditRepository;
        $this->userFunction = $userFunction;
        //$this->middleware(['role:administrator'], ['only' => ['adminindex']]);
        //$this->middleware(['role:administrator|superStockez|stockez'], ['only' => ['index']]);
    }

   
    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function index(Request $request,User $user)
    {
        
        if(auth()->user()->roles[0]->id==1) {
            $userList = User::pluck('email');
        }
        else {
        $userList = UserDetail::with(['user'])->where([['parent',auth()->user()->id],['status','active']])->get()->pluck('user.email');
        }
        $roleType = auth()->user()->roles[0]->name;
        $userDetails = UserDetail::with(['user','parentDetails'])->where([['user_id',auth()->user()->id],['status','active']])->first();
        
        return view('backend.credit.index')->withUserDetail($userDetails)->with(compact('roleType','userList'));
    }

    /**
     * @param Request $request
     *
     * @throws \Exception
     * @return mixed
     */
    public function creditDetails(Request $request)
    {
        $param = $request->only('userDetail');
        $sub_selectedUser = '';
        $userDetails = $this->creditRepository->getUserParticularCredit($param);
        $view = view("backend.credit.usercredit",compact('userDetails'))->render();
        return response()->json(['html'=>$view]);

    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function adjustCredit(Request $request, $userId = null)
    {
        $authUser = auth()->user()->id;
        $authRole = auth()->user()->roles[0]; 
        $roleType = auth()->user()->roles[0]->name;
        $userDetails = UserDetail::with(['user','parentDetails'])->where([['user_id',auth()->user()->id],['status','active']])->first();
        if($userId != '') {
            $userExistQuery = UserDetail::with(['user'])->where('user_id',$userId);
            if($authRole->id!=1) {
                $userExistQuery = $userExistQuery->where('parent',$authUser);
            }
            $userExist = $userExistQuery->first();
            
        } 
        if($userExist!='') {
            return view('backend.credit.adjust')->withUserDetail($userDetails)->with(compact('roleType','userExist'));
        }
        return view('backend.dashboard');
    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function transferCredit(Request $request, $userId = null)
    {
        $authUser = auth()->user()->id;
        $authRole = auth()->user()->roles[0]; 
        $roleType = auth()->user()->roles[0]->name;
        $userDetails = UserDetail::with(['user','parentDetails'])->where([['user_id',auth()->user()->id],['status','active']])->first();
        if($userId != '') {
            $userExistQuery = UserDetail::with(['user'])->where('user_id',$userId);
            if($authRole->id!=1) {
                $userExistQuery = $userExistQuery->where('parent',$authUser);
            }
            $userExist = $userExistQuery->first();
            
        } 
        if($userExist!='') {
            return view('backend.credit.transfer')->withUserDetail($userDetails)->with(compact('roleType','userExist'));
        }
        return view('backend.dashboard');
    }

     /**
     * @param Request $request
     *
     * @throws \Throwable
     * @return mixed
     */
    public function store(Request $request, $userId)
    {
        //throw new GeneralException(__('exceptions.backend.access.users.create_error'));
        $amount = $request->input('amount');
        $transactionKey = $request->input('transactionpassword');
        $creditType = $request->input('credittype');
        $param = $request->only(
            'amount',
            'transactionpassword',
            'credittype'
        );
        $param['userId']= $userId;
        
        $this->creditRepository->create($param);
        
        
        return redirect()->route('admin.auth.credit.index')->withFlashSuccess(__('alerts.backend.credit.updated'));
    }

    

    
}
